
texture rubyTexture;
float rubyTimer;

sampler s0 = sampler_state { texture = <rubyTexture>; };

float4 BlurPass( in float2 Tex : TEXCOORD0 ) : COLOR0
{	
    float2 Center   = {0.5, 0.5};
    float BlurStart = 1.0;
    float BlurWidth = -0.14;
    float samples   = 16;

    float4 Color = 0;
   
    for(int i = 0; i < samples; i++)
    {
       float scale = BlurStart + BlurWidth * (i / (samples - 1));
       Color      += tex2D(s0, (Tex - 0.5) * scale + Center );
    }
    Color /= samples;
    return Color;
}

Technique T0
{
    pass p0 { PixelShader = compile ps_2_0 BlurPass(); }
}

